﻿//<![CDATA[

// Calcula el Alto del IFrame en base al alto de la pagina que lo contiene
function calcHeight(strIFrameName) {
  var intHeight;
  var oIFrame;

  intHeight = 800;

  //Procesamiento del script
  try
  {
    oIFrame = window.parent.document.getElementsByName(strIFrameName)[0]; //obtengo el iFrame de la pagina padre
    intHeight = oIFrame.contentWindow.document.body.scrollHeight; //obtengo el alto de la pagina a abrir en el iFrame
    oIFrame.height = parseInt(intHeight); //cambio el alto del iFrame
  }
  catch(e)
  {}
  finally
  {
    intHeight = null;
    oIFrame = null;
  }
}

// Modifica el estado de los checkbox de una grilla (MarcarTodos/DesmarcarTodos/Invertir)
// Parameters:
//            1. pAction = {'UNCHECKALL', 'CHECKALL', 'REVERSE'}
//            2. pChkName = El nombre del check a modificar (su propiedad 'ID')
function ChangeStatusCheckBox(pAction, pChkName)
{
  var objInputs;
  var objInput;

  // Search on all Input Tags.
  objInputs = document.getElementsByTagName('input');

  switch (pAction)
  {
    case "UNCHECKALL":
      for (var i = 0; i < objInputs.length - 1; i++)
      {
        // Get Input that acts as a Filter
        objInput = objInputs.item(i);
        if(objInput.type == 'checkbox' && (objInput.parentNode.getAttribute('name') == pChkName || objInput.name == pChkName))
          objInput.checked = false;
      }
      break;
    case "CHECKALL":
      for (var i = 0; i < objInputs.length - 1; i++)
      {
        // Get Input that acts as a Filter
        objInput = objInputs.item(i);
        if(objInput.type == 'checkbox' && (objInput.parentNode.getAttribute('name') == pChkName || objInput.name == pChkName))
          objInput.checked = true;
      }
      break;
    case "REVERSE":
      for (var i = 0; i < objInputs.length - 1; i++)
      {
        // Get Input that acts as a Filter
        objInput = objInputs.item(i);
        if(objInput.type == 'checkbox' && (objInput.parentNode.getAttribute('name') == pChkName || objInput.name == pChkName))
          objInput.checked = !objInput.checked;
      }
      break;
  }

  return false; //para que no me ejecute el evento click del servidor
}

// Modifica el estado de los checkbox de una grilla (MarcarTodos/DesmarcarTodos/Invertir) contenida dentro de otra
// Parameters:
//            1. pAction = {'UNCHECKALL', 'CHECKALL', 'REVERSE'}
//            2. pChkCategory = Categoria a la cual pertenece el check (su propiedad 'category')
//            3. pChkHeader = {'Header', 'HeaderUnAssigned', 'HeaderAssigned'}
function ChangeStatusCheckBoxComplex(pAction, pChkCategory, pChkHeader)
{
  var objInputs;
  var objInput;

  // Search on all Input Tags.
  objInputs = document.getElementsByTagName('input');

  switch (pAction.toUpperCase())
  {
    case "UNCHECKALL":
      for (var i = 0; i < objInputs.length - 1; i++)
      {
        // Get Input that acts as a Filter
        objInput = objInputs.item(i);
        if (objInput.type == 'checkbox')
        {
          if (objInput.parentNode.getAttribute('category') != null && (objInput.parentNode.getAttribute('category') == pChkCategory || objInput.parentNode.getAttribute('category') == pChkHeader))
            objInput.checked = false;
          if (objInput.getAttribute('category') != null && (objInput.getAttribute('category') == pChkCategory || objInput.getAttribute('category') == pChkHeader))
            objInput.checked = false;
        }
      }
      break;
    case "CHECKALL":
      for (var i = 0; i < objInputs.length - 1; i++)
      {
        // Get Input that acts as a Filter
        objInput = objInputs.item(i);
        if (objInput.type == 'checkbox')
        {
          if (objInput.parentNode.getAttribute('category') != null && (objInput.parentNode.getAttribute('category') == pChkCategory || objInput.parentNode.getAttribute('category') == pChkHeader))
            objInput.checked = true;
          if (objInput.getAttribute('category') != null && (objInput.getAttribute('category') == pChkCategory || objInput.getAttribute('category') == pChkHeader))
            objInput.checked = true;
        }
      }
      break;
    case "REVERSE":
      for (var i = 0; i < objInputs.length - 1; i++)
      {
        // Get Input that acts as a Filter
        objInput = objInputs.item(i);
        if (objInput.type.toUpperCase() == 'CHECKBOX')
        {
          if (objInput.parentNode.getAttribute('category') != null && objInput.parentNode.getAttribute('category') == pChkCategory)
            objInput.checked = !objInput.checked;
          if (objInput.getAttribute('category') != null && objInput.getAttribute('category') == pChkCategory)
            objInput.checked = !objInput.checked;
          if (objInput.parentNode.getAttribute('category') != null && objInput.parentNode.getAttribute('category') == pChkHeader)
            objInput.checked = false;
          if (objInput.getAttribute('category') != null && objInput.getAttribute('category') == pChkHeader)
            objInput.checked = false;
        }
      }
      break;
  }

  return false; //para que no me ejecute el evento click del servidor
}

// Modifica el estado de los checkbox de una Organizacion (Marca todo o Desmarca todo)
// Parameters:
//            1. sender = CheckBox que produjo la llamada
//            2. pOrgId = Id de la Organizacion a la cual pertenece el Check
function CheckUnCheckAll(sender, pOrgId)
{
  var objInputs;
  var objInput;

  // Search on all Input Tags.
  objInputs = document.getElementsByTagName('input');
  
  for (var i = 0; i < objInputs.length; i++)
  {
    // Get Input that acts as a Filter
    objInput = objInputs.item(i);
    if (objInput.type == 'checkbox')
    {       
      if (objInput.parentNode.getAttribute('organizationId') != null && objInput.parentNode.getAttribute('organizationId') == pOrgId)
        objInput.checked = sender.checked;
      if (objInput.getAttribute('organizationId') != null && objInput.getAttribute('organizationId') == pOrgId)
        objInput.checked = sender.checked;
    }
  }
}

// Modifica el estado de los RadioButton
// Parameters:
//            1. sender = RadioButton que produjo la llamada
//            2. pCategory = Categoria a la que pertenece el RadioButton
function CheckOneUnCheckAllRadio(sender, pCategory)
{
  var objInputs;
  var objInput;

  // Search on all Input Tags.
  objInputs = document.getElementsByTagName('input');
  
  for (var i = 0; i < objInputs.length; i++)
  {
    // Get Input that acts as a Filter
    objInput = objInputs.item(i);
    
    // Desasigno todos los RadioButton
    if (objInput.type.toUpperCase() == 'RADIO')
    {  
      if (objInput.getAttribute('category') != null && objInput.getAttribute('category').toUpperCase() == pCategory.toUpperCase())
        objInput.checked = '';
    }
  } //-End For-

  // Asigno el RadioButton correcto
  sender.checked = 'checked'; 
}

// Checkea un solo CheckBox de acuerdo al radioButton seleccionado
// Parameters:
//            1. sender = RadioButton que produjo la llamada
function CheckOne(sender)
{
  var objInputs;
  var objInput;

  if (sender.getAttribute('orgIdUoId') != null)
  {
    // Search on all Input Tags.
    objInputs = document.getElementsByTagName('input');
  
    for (var i = 0; i < objInputs.length; i++)
    {
      // Get Input that acts as a Filter
      objInput = objInputs.item(i);
      
      // Desasigno todos los RadioButton
      if (objInput.type.toUpperCase() == 'CHECKBOX')
      {
        if (objInput.getAttribute('orgIdUoId') != null && objInput.getAttribute('orgIdUoId') == sender.getAttribute('orgIdUoId'))
        {
          // si necesito guardar el estado del radiobutton
          if (document.getElementById('hidOrgIdUoId') != null)
          {
            document.getElementById('hidOrgIdUoId').value = objInput.getAttribute('orgIdUoId');
          }
          
          objInput.checked = true;
          return;
        }
      }
    } //-End For-
  }   
}

function callNormalizer(szObjId) {
  var opera = (navigator.userAgent.indexOf("Opera") >= 0) ? true : false;
  var ie = (document.all && !opera) ? true : false;
  var obj  = document.getElementById(szObjId);
  var iNewHeight, iBottomPadding;
  
  if (obj != null) {
    iBottomPadding = 70;
    if (ie)
      iNewHeight = parseInt(document.documentElement.clientHeight) - iBottomPadding;
    else
      iNewHeight = parseInt(window.innerHeight) - iBottomPadding
      
    //- Seteo finalmente la altura del iFrame
    obj.style.height = iNewHeight + "px";
  }
}
//]]>
function ConfirmDelete(pTypeEntity, pEntityId)
    {
      var mRes;
      var strConfirm;
      var strMsg;
      
      strConfirm = 'Recuerde que no podrá deshacer los cambios sobre ';
      strMsg = '¿Desea eliminar ';
      switch (pTypeEntity)
      {
        case "ORG":
          strMsg += 'la organización ';
          strConfirm += 'la organización ';
          break;
        case "UO":
          strMsg += 'la unidad operacional ';
          strConfirm += 'la unidad operacional ';
          break;
        case "PRF":
          strMsg += 'el perfil ';
          strConfirm += 'el perfil ';
          break;
        case "USR":
          strMsg += 'el usuario ';
          strConfirm += 'el usuario ';
          break;
        case "Lng":
          strMsg += 'el Lenguaje ';
          strConfirm += 'el Lenguaje ';
          break;
        case "Rss":
          strMsg += 'el Rss ';
          strConfirm += 'el Rss ';
          break;
        case "Item":
          strMsg += 'el Item ';
          strConfirm += 'el Item ';
          break;
        case "Group":
          strMsg += 'el Grupo ';
          strConfirm += 'el Grupo ';
          break;
        default:
          return false
          break;
      }
      if (window.confirm(strMsg + '"' + pEntityId + '"?') == true)
      {
        if (window.confirm(strConfirm + '"' + pEntityId + '"') == true) return true;
      }        
      return false;
}
